using System;
using System.Collections.Generic;

namespace Programme
{
    class Article
    {
        public int weight;
        public int value;
        public float valuePerWeight;

        public Article(int weight, int value)
        {
            this.weight = weight;
            this.value = value;
            valuePerWeight = (float)value / (float)weight;
        }
    }

    class Program
    {
        static void Main()
        {
            string[] input = Console.ReadLine().Split();
            int n = int.Parse(input[0]);
            int W = int.Parse(input[1]);
            float e = float.Parse(input[2]);

            Article[] articles = new Article[n];

            for (int i = 0; i < n; i++)
            {
                input = Console.ReadLine().Split();
                articles[i] = new Article(int.Parse(input[0]), int.Parse(input[1]));
            }

            int[] dp = new int[W + 1];
            int[,] taken = new int[n, W + 1];

            for (int i = 0; i < n; i++)
            {
                for (int w = W; w >= articles[i].weight; w--)
                {
                    int newValue = dp[w - articles[i].weight] + articles[i].value;
                    if (newValue > dp[w])
                    {
                        dp[w] = newValue;
                        taken[i, w] = 1;
                    }
                }
            }

            List<int> usedItems = new List<int>();
            int remainingWeight = W;
            for (int i = n - 1; i >= 0; i--)
            {
                if (remainingWeight >= articles[i].weight && taken[i, remainingWeight] == 1)
                {
                    usedItems.Add(i + 1);
                    remainingWeight -= articles[i].weight;
                }
            }

            usedItems.Reverse();
            Console.WriteLine(string.Join(" ", usedItems));
        }
    }
}